#ifndef _DXGRAPHICSINIT_H
#define _DXGRAPHICSINIT_H

#include <Carbon/Carbon.h>
#include <AGL/agl.h>
#include "WinDataTypes.h"
#ifdef DXGRAPHICS_VERSION9
#include "d3d9.h"
#include "d3dx9.h" 
#endif  //DXGRAPHICS_VERSION8
#ifdef DXGRAPHICS_VERSION8
#include "d3d8.h"
#include "d3dx8.h" 
#endif

//int dxgl_option = 0; //shilpa-  29 oct 04
#ifdef DXGRAPHICS_VERSION9
IDirect3D9 * WINAPI Direct3DCreate9(UINT SDKVersion);
#endif

#ifdef DXGRAPHICS_VERSION8
IDirect3D8 * WINAPI Direct3DCreate8(UINT SDKVersion);
#endif

// MacOS GL Driver
struct GL_Driver_Information 
{
	AGLContext  pContext;
	GWorldPtr	pGWorld;
	WindowPtr	hWnd;
	UINT		f_lAdapter;
	int			nmode;
	int			width;
	int			height;
	CFDictionaryRef f_PrevDisplayMode; //In case of fullscreen mode, we need the previous display mode to reset the settings in Reset function.
	
};


struct GL_PresentParams
{
	Boolean f_bIsFullScreen;
	Boolean f_bEnableStenciling;
};

//Shilpa on 14 Apr 05 - moved to here
/*!
\enum   eOGL_EXTS
\brief  This is to enumerate various OopenGL extensions getting used in RoboDXGL.
\detail We check for the various required OpenGL extension support when a IDirect3D9 object gets created
*/
typedef enum 
{
	ke_ARB_Multitexture = 0,
	ke_EXT_TextureFilterAnisotropic,
	ke_ARB_TextureMirroredRepeat,
	ke_ATI_TextureMirrorOnce,
	ke_ARB_PointParameters,
	ke_NV_PointSprite,
	ke_APPLE_VertexArrayRange,
	ke_OGLEXTCount // This will indicate the count of extensions in this enum
}eOGL_EXTS;



void GL_GetViewportSize(GL_Driver_Information *pDevice, int *lx, int *ly);

void GL_GetCreationParameters(struct GL_Driver_Information *pDevice, struct _D3DDEVICE_CREATION_PARAMETERS *p);


void GL_DefaultSettings(GL_PresentParams in_GLPresentParams,int width, int height);

void *glAllocateMemory(int size);

void glFreeMemory(void *ptr);

void GL_GetAdapterDisplayMode(struct GL_Driver_Information *pDevice, UINT *width, UINT *height, UINT *bpp, UINT *refreshRate);

void GL_GetAdapterName(struct GL_Driver_Information *pDevice, int index, char *s, int numBytes);

int GL_GetAdapterModeCount(struct GL_Driver_Information *pDevice);

int GL_GetAdapterCount(struct GL_Driver_Information *pDevice);

void GL_EnumAdapterModes(struct GL_Driver_Information *pDevice, int index, UINT *width, UINT *height, UINT *bpp, UINT *refreshRate);

void GL_PresentDevice(struct GL_Driver_Information *pDevice, void * hwndOverride,GL_PresentParams in_GLPresentParams);

//Shilpa on 6 Nov 04 added an input parameter to handle fullscreen apps.
int GL_CreateDevice(struct GL_Driver_Information **pDevice, void *hwnd, int deviceId, int width, int height,GL_PresentParams in_GLPresentParams);

int GL_CreatePseudoDevice(struct GL_Driver_Information **pDevice);

void GL_ReleaseDevice(struct GL_Driver_Information *pDevice);

//! This function can be used to create a dummy context. 
//! This can be used to create a dummy context before calling glGetString if an OpenGL context has not been created already(otherwise glGetString will crash)
int CreateDummyContext(AGLContext *out_pContext); //Shilpa on 14 Apr 05

//! This function can be used to destroy the context and set the current context to NULL. This is used in DXGraphics to destroy the dummy context created.
void DestroyContext(AGLContext* in_pContext); //Shilpa on 14 Apr 05

#endif // _DXGRAPHICSINIT_H

